function load_css( path_to_stylesheet )
{
	var elm = document.createElement( 'link' );
	elm.type = 'text/css';
	elm.rel = 'stylesheet';
	elm.href = path_to_stylesheet;
	document.getElementsByTagName( 'head' )[0].appendChild( elm );
}

String.prototype.splitCSV = function( sep )
{
	var tl;
	var foo = this.split( sep = sep || '|' );

	for ( var x = foo.length - 1; x >= 0; x-- )
	{
		if ( foo[x].replace( /"\s+$/, '"' ).charAt( foo[x].length - 1 ) == '"' )
		{
			if ( ( tl = foo[x].replace( /^\s+"/, '"' ) ).length > 1 && tl.charAt( 0 ) == '"' )
			{
				foo[x] = foo[x].replace( /^\s*"|"\s*$/g, '' ).replace( /""/g, '"' );
			}
			else if (x)
			{
				foo.splice( x - 1, 2, [ foo[x - 1], foo[x] ].join( sep ) );
			}
			else
			{
				foo = foo.shift().split( sep ).concat( foo );
			}
		}
		else
		{
			foo[x].replace( /""/g, '"' );
		}
	}

	return foo;
};

String.prototype.encodeSpecialChar = function()
{
	var string = this.valueOf();
	var result = '';
	var code = '';

	for ( var i = 0; i < string.length; i++ )
	{
		code = string[i].charCodeAt(0);
		if ( code > 127 )
		{
			var hexcode = code.toString( 16 );
			result += '\\u' + '000'.substr( 0, 4 - hexcode.length ) + hexcode;
		}
		else
		{
			result += string[i];
		}
	}

	return result;
};

String.prototype.parseTime = function()
{
	var string = this.valueOf();
	
	if ( string == '' )
	{
		return null;
	}

	var time = string.match( /([0-2][0-9])([0-5][0-9])/ );
	
	if ( time != null )
	{
		return '' + parseInt( time[1], 10 ) + '.' + time[2];
	}

	time = string.match( /(\d+)([.,:/](\d\d))?\s*([pa]?)/i ); 

	if ( time == null )
	{
		return null;
	}

	var hours = parseInt( time[1], 10 );

	if ( hours > 23 )
	{
		return null;
	}
	else if ( hours == 12 && time[4] == 'a' )
	{
		hours = 0;
	}
	else if ( hours < 12 && time[4] == 'p' )
	{
		hours += 12;
	}   

	var minutes = parseInt( time[3], 10 ) || 0;

	if ( minutes > 59 )
	{
		minutes = 0;
	}

	return '' + hours + ':' + ( minutes < 10 ? '0' : '' ) + minutes;
};

String.prototype.parsePrice = function()
{
	var string = this.valueOf();
	
	if ( string == '' )
	{
		return null;
	}

	var price = string.match( /(\d+)([.,](\d)(\d)?)?/ ); 

	if ( price == null )
	{
		return null;
	}

	var euros = parseInt( price[1], 10 );
	var cents = 0;
	
	if ( price[2] )
	{
		cents = parseInt( price[3] + ( price[4] ? price[4] : '0' ), 10 );
	}

	return '' + euros + ',' + ( cents < 10 ? '0' : '' ) + cents;
};

function csv2data( string, min_rows )
{
	if ( ! string )
	{
		return;
	}
	
	var data = [];
	var rows = string.splitCSV( "\n" );

	for ( var i = 0; i < rows.length; i++ )
	{
		var cols = rows[ i ].splitCSV();
		var item = { "num": i + 1 };

		for ( var j = 0; j < cols.length; j++ )
		{
			item[ j ] = cols[ j ];
		}
		
		data.push( item );
	}
	
	if ( i < min_rows )
	{
		for ( 1; i < min_rows; i++ )
		{
			data.push( { "num": i + 1 } );
		}
	}
	
	return data;
}

function data2csv( data, sep )
{
	sep = sep || '|';
	var result = '';
	var used_rows = 0;
	var used_cols = 0;

	for ( var row = 0; row < data.length; row++ )
	{
		for ( var col in data[ row ] )
		{
			if ( col != 'num' && data[ row ][ col ] )
			{
				used_rows = row;
				col = parseInt( col );
				used_cols = col > used_cols ? col : used_cols;
			}
		}
	}
	
	for ( var row = 0; row <= used_rows; row++ )
	{
		if ( row > 0 )
		{
			result += "\n";
		}
		
		for ( var col = 0; col <= used_cols; col++ )
		{
			if ( col > 0 )
			{
				result += sep;
			}

			var needsquote = false;

			if ( data[ row ][ col ] )
			{
				needsquote = data[ row ][ col ].indexOf( sep ) >= 0 || data[ row ][ col ].indexOf( '"' ) >= 0;
				
				if ( needsquote )
				{
					result += '"' + data[ row ][ col ] + '"';
				}
				else
				{
					result += data[ row ][ col ];
				}
			}
		}
	}
	
	return result;
}


function data2json( data )
{
	var result = '';

	for ( var row = 0; row <= used_rows; row++ )
	{
		if ( row > 0 )
		{
			result += "\n";
		}
		
		for ( var col = 0; col <= used_cols; col++ )
		{
			if ( col > 0 )
			{
				result += sep;
			}

			var needsquote = false;

			if ( data[ row ][ col ] )
			{
				needsquote = data[ row ][ col ].indexOf( sep ) >= 0 || data[ row ][ col ].indexOf( '"' ) >= 0;
				
				if ( needsquote )
				{
					result += '"' + data[ row ][ col ] + '"';
				}
				else
				{
					result += data[ row ][ col ];
				}
			}
		}
	}
	
	return result;
}
