<?php

// TODO: Header so setzen, dass Browser-Cache ausgenutzt wird (konfigurierbare Zeitspanne)

function resize( $image, $dst_width, $dst_height, $force, $expand ) 
{
	$img_width = imagesx( $image );
	$img_height = imagesy( $image );
	$src_width = $img_width;
	$src_height = $img_height;

	if ( $dst_height == 0 && $dst_width == 0 )
	{
		// keine Gre vorgegeben
		$dst_width = $img_width;
		$dst_height = $img_height;
	}
	elseif ( $dst_height == 0 )
	{
		// nur Breite vorgegeben

		if ( ! $expand && $img_width < $dst_width )
		{
			$dst_width = $img_width;
			$dst_height = $img_height;
		}
		else
		{
			$dst_height = round( $img_height * $dst_width / $img_width );
		}
	}
	elseif ( $dst_width == 0 )
	{
		// nur Hhe vorgegeben

		if ( ! $expand && $img_height < $dst_height )
		{
			$dst_width = $img_width;
			$dst_height = $img_height;
		}
		else
		{
			$dst_width = round( $img_width * $dst_height / $img_height );
		}
	}
	else
	{
		// Breite UND Hhe vorgegeben

		if ( ! $expand && $img_width < $dst_width && $img_height < $dst_height )
		{
			// Bild ist kleiner als vorgegebener Rahmen und Vergrerung ist untersagt

			$dst_width = $img_width;
			$dst_height = $img_height;
		}
		elseif ( $force )
		{
			// Bild beschneiden, um den Rahmen ganz zu fllen

			if ( $dst_width / $img_width > $dst_height / $img_height )
			{
				$src_height = $dst_height * $src_width / $dst_width;
			}
			else
			{
				$src_width = $dst_width * $src_height / $dst_height;
			}

		}
		else
		{
			// Bild proportional verkleinern und einpassen

			if ( $dst_width / $img_width > $dst_height / $img_height )
			{
				$dst_width = $img_width * $dst_height / $img_height;
			}
			else
			{
				$dst_height = $img_height * $dst_width / $img_width;
			}
		}

	}

	if ( $dst_width == $img_width &&	$dst_height == $img_height )
	{
		$new_image = &$image;
	}
	else
	{
		$new_image = imagecreatetruecolor( $dst_width, $dst_height ); 
		imagecopyresampled( $new_image, $image, 0, 0, 0, 0, $dst_width, $dst_height, $src_width, $src_height );
	}

	return $new_image;
}	


function cleanup( $path, $max_size, $max_files = 0, $max_age = 0, $min_interval = 0 )
{
	$path = rtrim( $path, '/' );
	
	if ( $min_interval > 0 )
	{
		if ( file_exists( "{$path}/_cleanup" ) 
				&& time() - filemtime ( "{$path}/_cleanup" ) < $min_interval )
		{
			return;
		}
	}

	touch( "{$path}/_cleanup" );

	$list = array();
	$size = 0;
	$dir = opendir( $path );

	if ( ! $dir )
	{
		return FALSE; // could not open directory
	}
	
	while ( ( $item = readdir( $dir ) ) !== FALSE )
	{
		if ( $item == '_cleanup' )
		{
			continue;
		}

		$file = $path . '/' . $item;

		if ( ! is_file( $file ) )
		{
			continue;
		}

		$list[ $file ] = filemtime( $file );
		$size += filesize( $file );
	}

	closedir( $dir );
	asort( $list );
	reset( $list );
	$count = count( $list );
	
	if ( $max_age > 0 )
	{
		$limit = time() - ( $max_age * 24 * 60 * 60 );
		while ( filemtime( key( $list ) ) < $limit )
		{
			unlink( key( $list ) );
			array_shift( $list );
		}
	}

	if ( $max_files > 0 )
	{
		for ( $i = 0; $i < $count - $max_files; $i++ )
		{
			$size -= filesize( key( $list ) );
			unlink( key( $list ) );
			array_shift( $list );
		}
	}

	if ( $max_size > 0 )
	{
		while ( $size > $max_size )
		{
			$size -= filesize( key( $list ) );
			unlink( key( $list ) );
			array_shift( $list );
		}
	}
	
	return $count - count( $list );
}


function is_access_allowed( $folder )
{
	if ( file_exists( "{$folder}/.vt_allow" ) )
	{
		return TRUE;
	}

	do
	{
		if ( file_exists("{$folder}/.htaccess") 
				&& strpos( file_get_contents("{$folder}/.htaccess"), 'Deny' ) !== FALSE )
		{
			return FALSE;
		}

		$folder = dirname( $folder );
	}
	while ( $folder && $folder != VT_BASE_DIR );
	
	return TRUE;
}


function read_config( $path )
{
	$lines = file( $path );
	array_shift( $lines );
	array_pop( $lines );
	$config = array();

	foreach ( $lines as $line )
	{
		$line = trim( $line );

		if ( ! empty( $line ) && $line[0] != ';' && strpos( $line, '=' ) )
		{
			list( $field, $value ) = explode( '=', $line, 2 );
			$config[ trim( $field ) ] = trim( trim( $value ), '"\'' );
		}
	}

	return $config;
}



######## MAIN SCRIPT ###########


error_reporting( 0 );
ini_set( 'display_errors', 0 );

if ( ! function_exists( 'gd_info') )
{
	exit; // GD Library not installed
}


### set configuration parameters

define( 'VT_BASE_DIR', realpath( '../..' ) );
$config['imagerJpegQuality'] = 90;
$config['imagerCacheMaxSize'] = 1000000;
$config['imagerCacheMaxFiles'] = 0;
$config['imagerCacheMaxAge'] = 0;
$config['imagerCleanupInterval'] = 3600;

if ( file_exists( VT_BASE_DIR . '/config/config.php' ) )
{
	$config = array_merge( $config, read_config( VT_BASE_DIR . '/config/config.php' ) );
}

if ( empty( $config['imagerBasePath'] ) )
{
	if ( ! empty( $config['pathToMedia'] ) )
	{
		$config['imagerBasePath'] = $config['pathToMedia'];
	}
	elseif ( ! empty( $config['pathToData'] ) )
	{
		$config['imagerBasePath'] = $config['pathToData'] . 'media/';
	}
	else
	{
		$config['imagerBasePath'] = VT_BASE_DIR . '/data/media';
	}
}

if ( empty( $config['imagerCachePath'] ) )
{
	if ( ! empty( $config['pathToCache'] ) )
	{
		$config['imagerCachePath'] = $config['pathToCache'] . 'images/';
	}
	else
	{
		$config['imagerCachePath'] = VT_BASE_DIR . '/cache/images';
	}
}


### clean up cache directory

cleanup( $config['imagerCachePath'], $config['imagerCacheMaxSize'], $config['imagerCacheMaxFiles'], $config['imagerCacheMaxAge'], $config['imagerCleanupInterval'] );


### collect request details

if ( empty( $_SERVER['PATH_INFO'] ) && empty( $_SERVER['ORIG_PATH_INFO'] ) )
{
	exit; // no image file specified
}

$image = trim( empty( $_SERVER['PATH_INFO'] ) ? $_SERVER['ORIG_PATH_INFO'] : $_SERVER['PATH_INFO'], '/' );

if ( strpos( $image, '../' ) !== FALSE )
{
	exit; // back links not allowed in image path
}

if ( substr( $image, 0, 2 ) == '-/' )
{
	$image = VT_BASE_DIR . substr( $image, 1 );
	
	if ( ! is_access_allowed( dirname( $image ) ) )
	{
		exit; // access to image file is not allowed
	}
}
else
{
	$image = $config['imagerBasePath'] . '/' . $image;
}

if ( ! file_exists( $image ) )
{
	exit; // image file does not exist
}

$info = getimagesize( $image );

if ( ! $info )
{
	exit; // unsupported file type
}

$image_type = $info[2];
unset( $info );

$directive = $_SERVER['QUERY_STRING'];

$width = 0;
$height = 0;
$force = 0;
$expand = 0;

if ( strpos( $directive, 'f' ) !== FALSE )
{
	$force = 1;
	$directive = str_replace( 'f', '', $directive );
}

if ( strpos( $directive, 'x' ) !== FALSE )
{
	$expand = 1;
	$directive = str_replace( 'x', '', $directive );
}

if ( is_numeric( $directive ) )
{
	$width = $directive;
	$height = $directive;
}
else
{
	if ( preg_match( '/[wW]([0-9]+)/', $directive, $matches ) )
	{
		$width = $matches[1];
	}

	if ( preg_match( '/[hH]([0-9]+)/', $directive, $matches ) )
	{
		$height = $matches[1];
	}
}


### check or create image file

if ( $width == 0 && $height == 0 )
{
	$file = $image;
}
else
{
	$hash = sha1( "{$image}w{$width}h{$height}{$force}{$expand}" . filemtime( $image ) . filesize( $image ) );
	$file = $config['imagerCachePath'] . '/' . $hash;

	if ( ! file_exists( $file ) )
	{
		switch ( $image_type )
		{
			case IMAGETYPE_JPEG:
				if ( ! function_exists( 'imagecreatefromjpeg' ) )
				{
					exit; // jpeg images not supported by this gd installation
				}
				$image_data = imagecreatefromjpeg( $image );
				break;
			case IMAGETYPE_PNG:
				if ( ! function_exists( 'imagecreatefrompng' ) )
				{
					exit; // png images not supported by this gd installation
				}
				$image_data = imagecreatefrompng( $image );
				break;
			case IMAGETYPE_GIF:
				if ( ! function_exists( 'imagecreatefromgif' ) )
				{
					exit; // gif images not supported by this gd installation
				}
				$image_data = imagecreatefromgif( $image );
				break;
			default:
				exit; // unsupported image type
		}

		$result = resize( $image_data, $width, $height, $force, $expand );

		if ( is_resource( $result ) || is_object( $result ) )
		{
			imagejpeg( $result, $file, $config['imagerJpegQuality'] );
		}
		else
		{
			$file = $image;
		}
		
	}
	else
	{
		touch( $file );
	}
}


### deliver image file

header( 'Content-type: image/jpeg' );
header( 'Content-Transfer-Encoding: binary' );
header( 'Content-Length: ' . filesize( $file ) );
flush();
readfile( $file );
exit;
	
// end of file imager.php
