<?php

class Persistent_Logins {
	
	var $db;
	var $table;
	var $cookieName = 'uauth_tk';
	var $loginPeriod = 7; //days
	var $tokenCharacters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
	var $tokenLength = 62;
	var $separator = '-';


	function __construct( &$db, $table = 'persistent_logins' )
	{
		$this->db = &$db;
		$this->table = $table;
		$this->init();
	}

	
	function init()
	{
		$sql = "CREATE TABLE IF NOT EXISTS `{$this->table}` (
						`id` int(11) unsigned NOT NULL AUTO_INCREMENT,
						`user_id` int(11) unsigned DEFAULT NULL,
						`token` varchar(40) DEFAULT NULL,
					   `expiration_date` date DEFAULT NULL,
						PRIMARY KEY (`id`)
					) ENGINE='MyISAM' COLLATE 'utf8_unicode_ci'";

		$this->db->query( $sql );
	}
	
	
	function validate()
	{
		if ( empty( $_COOKIE[ $this->cookieName ] ) )
		{
			return FALSE;
		}

		list( $id, $token ) = explode( $this->separator, $_COOKIE[ $this->cookieName ] );
		
		if ( empty( $token ) )
		{
			return FALSE;
		}

		$id = (int) $id;
		$token = $this->_hash( $token );
		$sql = "SELECT `user_id` FROM `{$this->table}` WHERE `token` = '{$token}' AND `expiration_date` > CURDATE()";
		$result = $this->db->query( $sql );
		
		if ( ! $result || ! $result->num_rows )
		{
			return FALSE;
		}

		$this->invalidate();
		$row = $result->fetch_assoc();
		$this->make_persistent( $row['user_id'] );
		return $row['user_id'];
	}


	function make_persistent( $userId )
	{
		$token = '';
		$maxPosition = strlen( $this->tokenCharacters ) - 1;
		$this->invalidate();

		while ( strlen( $token ) < $this->tokenLength )
		{
			$token .= $this->tokenCharacters[ rand( 0, $maxPosition ) ];
		}

		$hash = sha1( $token );
		$expirationDate = date( 'Y-m-d', strtotime( 'today +' . $this->loginPeriod . ' days' ) );
		$sql = "INSERT INTO `{$this->table}` SET 
			`user_id` = '{$userId}', 
			`token` = '{$hash}', 
			`expiration_date` = '{$expirationDate}'";
	
		if ( $this->db->query( $sql ) && $this->db->insert_id )
		{
			$this->lastLoginId = $this->db->insert_id;
			$cookieValue = $this->db->insert_id . $this->separator . $token;
			setcookie( $this->cookieName, $cookieValue, strtotime( $expirationDate ), '/', NULL, TRUE, TRUE );
		}
	}
	

	function invalidate()
	{
		if ( ! empty( $this->lastLoginId ) )
		{
			$sql = "DELETE FROM `{$this->table}` WHERE `id` = {$this->lastLoginId}";
			$this->db->query( $sql );
		}

		if ( ! empty( $_COOKIE[ $this->cookieName ] ) )
		{
			list( $id, $token ) = explode( $this->separator, $_COOKIE[ $this->cookieName ] );
			$id = (int) $id;
			$sql = "DELETE FROM `{$this->table}` WHERE `id` = {$id}";
			$this->db->query( $sql );
		}

		setcookie( $this->cookieName, FALSE, time() - 3600, '/', NULL, TRUE, TRUE );
	}


	function invalidate_all( $userId )
	{
		$userId = (int) $userId;
		$sql = "DELETE FROM `{$this->table}` WHERE `user_id` = '{$userId}'";
		return $this->db->query( $sql );
	}


	function tidy()
	{
		$sql = "DELETE FROM `{$this->table}` WHERE `expiration_date` < CURRENT_DATE";
		$this->db->query( $sql );
		return $this->db->affected_rows;
	}
	
	
	function _hash( $str )
	{
		return sha1( $str );
	}
}

// end of file