<?php

class Log_Manager {
	
	var $directory;
	var $debug;
	var $file_mode = 0777;
	var $file_prefix = 'log-';
	var $processId;


	function __construct( $directory, $debug = FALSE )
	{
		$this->directory = rtrim( $directory, '/' );
		$this->debug = $debug;
		$this->processId = substr( md5( microtime() ), -5 );
	}

	
	function write( $message, $debug = TRUE )
	{
		if ( $debug && ! $this->debug )
		{
			return;
		}

		$file = "{$this->directory}/{$this->file_prefix}" . date( 'Y-m-d' ) . '.php';
		$existed = file_exists( $file );
		$handle = fopen( $file, 'a' );

		if ( ! $handle )
		{
			return;
		}

		if ( ! $existed )
		{
			fwrite( $handle, "<?php die('Access denied'); ?>\n\n" );
			chmod( $file, $this->file_mode );
		}

		$type = $debug ? 'debug' : 'error';
		$entry = date( 'H:i:s' ) . "[{$this->processId}] [{$type}] $message\n";
		$result = fwrite( $handle, $entry );
		fclose( $handle );
	}


	function delete_old_files( $max_age )
	{
		if ( $max_age < 1 )
		{
			return;
		}

		$compareTime = time() - $max_age * 24 * 3600;
		$handle = opendir( $this->directory );

		if ( ! $handle )
		{
			return;
		}

		while ( ( $file = readdir( $handle ) ) !== FALSE )
		{
			if ( strpos( $file, $this->file_prefix ) !== 0 )
			{
				continue;
			}
			
			$age = strtotime( substr( $file, 4, -4 ) );
			
			if ( $age > 0 && $age < $compareTime )
			{
				@unlink( $this->directory . '/' . $file );
			}
		}

		closedir( $handle );
	}
}

// end of file