<?php

class File_Storage_Local {
	
	public $baseDir;
	public $baseUrl;
	public $directoryPrivileges = 0777;
	public $filePrivileges = 0777;
	
	// TODO: neue Objekte sollten jeweils in eigenen (Unter-)Ordner mit zufälligem Namen abgelegt werden (müsste durch aufrufende Funktionen umgesetzt werden)
	
	
	public function __construct( $baseDir, $baseUrl = '' )
	{
		$this->baseDir = rtrim( $baseDir, '/' );
		$this->baseUrl = rtrim( $baseUrl, '/' );
		
		if ( ! file_exists( $this->baseDir ) )
		{
			$oldUmask = umask( 0 );
			mkdir( $this->baseDir, $this->directoryPrivileges, TRUE );
			umask( $oldUmask );
		}
	}
	

	public function create( $reference, $data )
	{
		$targetDir = dirname( "{$this->baseDir}/{$reference}" );

		if ( ! file_exists( $targetDir ) )
		{
			$oldUmask = umask( 0 );
			$result = mkdir( $targetDir, $this->directoryPrivileges, TRUE );
			umask( $oldUmask );

			if ( ! $result )
			{
				return FALSE;
			}

		}

		if ( ! file_put_contents( "{$this->baseDir}/{$reference}", $data ) )
		{
			return FALSE;
		}
	
		@chmod( "{$this->baseDir}/{$reference}", $this->filePrivileges );
		return TRUE;
	}
	
	
	public function import( $reference, $file, $copyFile = FALSE )
	{
		// TODO: existierende Objekte überschreiben?

		$targetDir = dirname( "{$this->baseDir}/{$reference}" );

		if ( ! file_exists( $targetDir ) )
		{
			$oldUmask = umask( 0 );
			$result = mkdir( $targetDir, $this->directoryPrivileges, TRUE );
			umask( $oldUmask );

			if ( ! $result )
			{
				return FALSE;
			}

		}

		$result = copy( $file, "{$this->baseDir}/{$reference}" );

		if ( ! $result )
		{
			return FALSE;
		}

		if ( ! $copyFile )
		{
			unlink( $file );
		}

		@chmod( "{$this->baseDir}/{$reference}", $this->filePrivileges );
		return TRUE;
	}
	
	
	public function copy( $sourceRef, $targetRef )
	{
		return $this->import( $targetRef, "{$this->baseDir}/{$sourceRef}", TRUE );
	}


	public function get_list()
	{
		$list = scandir( $this->baseDir );
		return array_filter( $list, function( $v ){ return $v[0] != '.'; } );
	}


	public function exists( $reference )
	{
		return file_exists( "{$this->baseDir}/{$reference}" );
	}
	
	
	public function get_size( $reference )
	{
		$file = "{$this->baseDir}/{$reference}";

		if ( ! file_exists( $file ) )
		{
			return FALSE;
		}

		return filesize( $file );
	}
	
	
	public function get_url( $reference )
	{
		if ( empty( $this->baseUrl ) )
		{
			return FALSE;
		}

		$reference = str_replace( '%2F', '/', rawurlencode( $reference ) );
		return "{$this->baseUrl}/{$reference}";
	}


	public function get_contents( $reference )
	{
		$file = "{$this->baseDir}/{$reference}";

		if ( ! file_exists( $file ) )
		{
			return FALSE;
		}

		return file_get_contents( $file );
	}
	

	public function stream( $reference )
	{
		$file = "{$this->baseDir}/{$reference}";

		if ( ! file_exists( $file ) )
		{
			return FALSE;
		}

		return readfile( $file );
	}
	
	
	public function delete( $reference )
	{
		$file = "{$this->baseDir}/{$reference}";

		if ( ! file_exists( $file ) )
		{
			return FALSE;
		}

		if ( ! unlink( $file ) )
		{
			return FALSE;
		}
		
		do
		{
			$reference = dirname( $reference );
		}
		while ( $reference != '.' 
			&& ! @rmdir( "{$this->baseDir}/{$reference}" ) );
		
		return TRUE;
	}
	
	
	public function delete_by_prefix( $prefix )
	{
		$this->remove_recursive( "{$this->baseDir}/{$prefix}" );
	}


	private function remove_recursive( $dir )
	{
		if ( strpos( $dir, $this->baseDir ) !== 0 )
		{
			return;
		}

		if ( is_file( $dir ) )
		{
			unlink( $dir );
			return;
		}

		if ( ! is_dir( $dir ) )
		{
			return;
		}

		$list = array_filter( scandir( $dir ), function( $v ){ return $v[0] != '.'; } );

		foreach ( $list as $item )
		{
			if ( is_dir( $dir . '/' . $item ) )
			{
				$this->remove_recursive( $dir . '/' . $item );
			}
			else
			{
				unlink( $dir . '/' . $item );
			}
		}

		return rmdir( $dir );
	}
}


// end of file file_storage.php
