<?php

class mysqli_extended extends mysqli {
	
	public $tablePrefix = '';
	public $logFunction;
	public $debug = FALSE;

	private $tableNames = array ();
	private $columnNames = array ();
	
	
	public function __construct( $server, $username, $password, $database, $port = NULL, $socket = NULL )
	{
		parent::__construct( $server, $username, $password, $database, $port, $socket );
		mysqli_report( MYSQLI_REPORT_OFF );
	}


	#[\ReturnTypeWillChange]
	public function query( $sql, $resultmode = MYSQLI_STORE_RESULT )
	{
		if ( $this->tablePrefix )
		{
			$sql = str_replace( '`%', '`' . $this->tablePrefix, $sql );
		}

		$startTime = microtime( TRUE );
		$result = parent::query( $sql, $resultmode );
		$elapsedTime = microtime( TRUE ) - $startTime;

		if ( $result && ! $this->debug )
		{
			return $result;
		}
		
		$trace = debug_backtrace();
		array_shift( $trace );

		foreach ( $trace as $call )
		{
			$chain[] = str_replace( 'ƒ', '', $call['function'] );
		}

		$this->_log( '---------------------------------------------------------------------', ! $result );
		$this->_log( 'QUERY by ' . implode( ' < ', $chain ), ! $result );
		$this->_log( $sql, ! $result );
		$message = "RESULT [{$elapsedTime} ms]:";

		if ( $this->errno > 0 )
		{
			$this->_log( "{$message} MySQL-Error #{$this->errno}: {$this->error}", TRUE );
		}
		elseif ( is_object( $result ) )
		{
			$this->_log( "{$message} {$result->num_rows} record(s) found" );
		}
		else
		{
			$this->_log( "{$message} {$this->affected_rows} record(s) affected" );
		}

		$this->_log( '---------------------------------------------------------------------', ! $result );
		return $result;
	}
	
	
	public function table_exists( $tableName, $ignoreCache = FALSE )
	{
		if ( empty( $this->tableNames ) || $ignoreCache )
		{
			$this->tableNames = array ();
			$result = $this->query( "SHOW TABLES LIKE '{$this->tablePrefix}%'" );
		
			while ( $row = $result->fetch_row() )
			{
				$this->tableNames[] = substr( $row[0], strlen( $this->tablePrefix ) );
			}
		}
	
		return in_array( $tableName, $this->tableNames );
	}


	function column_exists( $tableName, $columnName )
	{
		if ( ! $this->table_exists( $tableName ) )
		{
			return FALSE;
		}

		if ( empty( $this->columnNames ) || empty( $this->columnNames[ $tableName ] ) )
		{
			$this->columnNames[ $tableName ] = array ();
			$result = $this->query( "SHOW COLUMNS FROM `{$tableName}`" );
			
			while ( $row = $result->fetch_row() )
			{
				$this->columnNames[ $tableName ][] = $row[0];
			}
		}

		return in_array( $columnName, $this->columnNames[ $tableName ] );
	}


	private function _log( $message, $isError = FALSE )
	{
		if ( ! is_callable( $this->logFunction ) )
		{
			return;
		}

		call_user_func( $this->logFunction, $message, $isError );
	}
}

// end of file
