<?php

/* Mime_Type_Mapper - Maps file extensions to MIME types and vice versa
 * Version 1.1
 * Copyright (c) 2012-2019, Martin Wandelt
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *  - Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

class Mime_Type_Mapper {
	
	public $mimeFile; // path to the mime.types file
	public $mapExtType; // array for extension - mime type mapping
	public $mapTypeExt; // array for mime type - extension mapping


	public function __construct( $mimeFile = '' )
	{
		if ( empty( $mimeFile ) )
		{
			$this->mimeFile = dirname( __FILE__ ) . '/mime.types';
		}
		else
		{
			$this->mimeFile = $mimeFile;
			
		}

		$this->read_mime_types();
	}


	public function get_type( $file )
	{
		$ext = pathinfo( $file, PATHINFO_EXTENSION );

		if ( ! $ext )
		{
			$ext = $file;
		}

		$ext = strtolower( $ext );
		return isset( $this->mapExtType[ $ext ] ) ? $this->mapExtType[ $ext ] : NULL;
	}


	public function get_extension( $type )
	{
		$type = strtolower( $type );
		return isset( $this->mapTypeExt[ $type ] ) ? $this->mapTypeExt[ $type ] : NULL;
	}


	private function read_mime_types()
	{
		$file = fopen( $this->mimeFile, 'r' );

		while ( ( $line = fgets( $file ) ) !== FALSE )
		{
			if ( $line[0] == '#' )
			{
				continue;
			}

			$parts = preg_split( '/\s+/', $line );

			if ( count( $parts ) == 1 )
			{
				continue;
			}

			$type = array_shift( $parts );
			$this->mapTypeExt[ $type ] = $parts[0];

			foreach( $parts as $part )
			{
				$this->mapExtType[ $part ] = $type;
			}
		}

		fclose( $file );
	}
}

// end of file mime-type-mapper.php
